#erase datafile from SD card
#20220820
#Paul Mirel

import os
import time
import sdcardio
import board
import busio
import digitalio
import storage
import terminalio

# Adalogger Featherwing uses pin D10 for the SDCard chip select line on the SPI bus
# THAT WAS A COLLISION, so I modified the SD card to use pin D11 for chip select
sd_cs = board.D11
spi_bus = board.SPI()
# Connect to the card and mount the filesystem.
sdcard = sdcardio.SDCard( spi_bus, sd_cs )
vfs = storage.VfsFat( sdcard )
storage.mount( vfs, "/sd" )
# Files are under /sd


input_string = False
print( "Are you sure you want to erase the 'data.txt' and/or 'batch.txt' from the SD card?")
print()
print( "1. For 'data.txt': Press 'x' and then <return> to delete the file. Press <return> only to continue to step 2 without deleting the file.")
while input_string == False:
    input_string = input().strip()
if input_string == "x":
    try:
        os.remove("/sd/data.txt")
        print( "'data.txt' file deleted." )
    except OSError as err:
        print( "File 'data.txt' was not found on the SD card" )

else:
    print( "'data.txt' was not deleted." )
print()
input_string = False
print( "2. For 'batch.txt': Press 'x' and then <return> to delete the file. Press <return> only to finish the code without deleting the file.")
while input_string == False:
    input_string = input().strip()
if input_string == "x":
    try:
        os.remove("/sd/batch.txt")
        print( "'batch.txt' file deleted." )
    except OSError as err:
        print( "File 'batch.txt' was not found on the SD card" )

else:
    print( "'batch.txt' was not deleted." )

print()
print( "Program Completed" )
